import numpy as np
from sklearn.datasets import load_iris
from sklearn.model_selection import cross_val_score, GridSearchCV
from sklearn.ensemble import RandomForestClassifier
from sklearn.metrics import classification_report

# Load Iris dataset
data = load_iris()
X, y = data.data, data.target

# Define model and parameter grid
model = RandomForestClassifier(random_state=42)
param_grid = {
    "n_estimators": [10, 50, 100],
    "max_depth": [3, 5, 10]
}

# Perform Grid Search with Cross-Validation
grid_search = GridSearchCV(model, param_grid, cv=5, scoring='accuracy')
grid_search.fit(X, y)

# Display best parameters and evaluation report
print("Best Parameters:", grid_search.best_params_)
print("Best Cross-Validation Score:", grid_search.best_score_)

# Final evaluation on the test set
best_model = grid_search.best_estimator_
y_pred = best_model.predict(X)
print("\nClassification Report:")
print(classification_report(y, y_pred))
