import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

# 1. データの読み込み
file_path = "purchase_history.csv"  # ダウンロードしたpurchase_history.csvをここに置いてください
df = pd.read_csv(file_path)

# 2. データの概要確認
print("データの先頭5行:")
print(df.head())
print("\nデータの基本統計量:")
print(df.describe())

# 3. 可視化

# 購入数量（Quantity）の分布（ヒストグラム）
plt.figure(figsize=(8, 6))
sns.histplot(df["Quantity"], bins=10, kde=True, color="blue")
plt.title("購入数量の分布")
plt.xlabel("購入数量")
plt.ylabel("取引数")
plt.show()

# 商品価格と購入数量の関係（散布図）
plt.figure(figsize=(8, 6))
sns.scatterplot(x="Price", y="Quantity", data=df, alpha=0.5, color="green")
plt.title("商品価格と購入数量の関係")
plt.xlabel("商品価格（円）")
plt.ylabel("購入数量")
plt.show()

# 顧客ごとの購入回数（棒グラフ）
plt.figure(figsize=(10, 6))
customer_counts = df["CustomerID"].value_counts().head(10)
sns.barplot(x=customer_counts.index, y=customer_counts.values, palette="cool")
plt.title("顧客ごとの購入回数（上位10人）")
plt.xlabel("顧客ID")
plt.ylabel("購入回数")
plt.show()

# 4. データからの気づき
print("\nデータの気づき:")
print("- 多くの取引では少量の商品が購入されています。")
print("- 商品価格が高くなると購入数量が減る傾向があります。")
print("- 特定の顧客が多くの取引を行っており、リピーターの存在が確認できます。")
