import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

# 1. データの読み込み
file_path = "sns_data.csv"  # ダウンロードしたsns_data.csvをここに置いてください
df = pd.read_csv(file_path)

# 2. データの概要確認
print("データの先頭5行:")
print(df.head())
print("\nデータの基本統計量:")
print(df.describe())

# 3. 可視化

# いいね数の分布（ヒストグラム）
plt.figure(figsize=(8, 6))
sns.histplot(df["Likes"], bins=10, kde=True, color="green")
plt.title("いいね数の分布")
plt.xlabel("いいね数")
plt.ylabel("投稿数")
plt.show()

# 投稿長さといいね数の関係（散布図）
plt.figure(figsize=(8, 6))
sns.scatterplot(x="PostLength", y="Likes", hue="Hashtags", size="Shares", sizes=(20, 200), data=df, palette="viridis")
plt.title("投稿の長さといいね数の関係")
plt.xlabel("投稿の長さ（文字数）")
plt.ylabel("いいね数")
plt.legend(title="ハッシュタグ数", bbox_to_anchor=(1.05, 1), loc="upper left")
plt.tight_layout()
plt.show()

# ユーザーごとの平均いいね数（棒グラフ）
plt.figure(figsize=(8, 6))
user_likes = df.groupby("Username")["Likes"].mean().reset_index()
sns.barplot(x="Username", y="Likes", data=user_likes, palette="pastel")
plt.title("ユーザーごとの平均いいね数")
plt.xlabel("ユーザー名")
plt.ylabel("平均いいね数")
plt.show()

# 4. データからの気づき
print("\nデータの気づき:")
print("- いいね数の分布を見ると、一部の投稿が特に高い人気を得ていることがわかります。")
print("- 投稿の長さが長いほどいいね数が増える傾向がありますが、ハッシュタグ数やシェア数も影響しています。")
print("- 特定のユーザーが他のユーザーに比べて多くのいいねを獲得していることがわかります。")
