import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns

# 1. サンプルデータの生成
def generate_data():
    np.random.seed(42)
    data = {
        "CustomerID": range(1, 101),
        "Age": np.random.randint(18, 65, 100),
        "Gender": np.random.choice(["Male", "Female"], 100, p=[0.5, 0.5]),
        "PurchaseAmount": np.random.normal(2000, 500, 100).round(2),
        "VisitFrequency": np.random.choice([1, 2, 3, 4, 5], 100, p=[0.2, 0.3, 0.3, 0.1, 0.1])
    }
    return pd.DataFrame(data)

# データセット生成
df = generate_data()

# 2. データの概要確認
print("データの先頭5行:")
print(df.head())
print("\nデータの基本統計量:")
print(df.describe())

# 3. 可視化

# 年齢分布（ヒストグラム）
plt.figure(figsize=(8, 6))
sns.histplot(df["Age"], bins=10, kde=True, color="skyblue")
plt.title("年齢分布")
plt.xlabel("年齢")
plt.ylabel("顧客数")
plt.show()

# 購入金額と訪問頻度の散布図
plt.figure(figsize=(8, 6))
sns.scatterplot(x="VisitFrequency", y="PurchaseAmount", hue="Gender", data=df, palette="Set2")
plt.title("購入金額と訪問頻度の関係")
plt.xlabel("訪問頻度（月間）")
plt.ylabel("購入金額（円）")
plt.show()

# 性別ごとの平均購入金額（棒グラフ）
plt.figure(figsize=(8, 6))
sns.barplot(x="Gender", y="PurchaseAmount", data=df, palette="pastel", ci=None)
plt.title("性別ごとの平均購入金額")
plt.xlabel("性別")
plt.ylabel("平均購入金額（円）")
plt.show()

# 4. データからの気づき
print("\nデータの気づき:")
print("- 年齢層では30〜40歳付近が多いことがわかります。")
print("- 訪問頻度が多いほど、購入金額が高い傾向があります。")
print("- 性別ごとに平均購入金額を比較すると、わずかに違いが見られます。")
